<?php
/**
 * Plugin Name: Strava Widgets by dasFLOSEN
 * Description: Connects to Strava via OAuth2 and provides widgets/shortcodes for activities, stats, and latest activity.
 * Version: 0.2.29
 * Author: dasFLOSEN
 */

if (!defined('ABSPATH')) exit;

define('SW_STRAVA_VER', '0.1.0');
define('SW_STRAVA_OPT', 'sw_strava_options');
define('SW_STRAVA_BASE', plugin_dir_path(__FILE__));

require_once SW_STRAVA_BASE . 'includes/class-strava-api.php';
require_once SW_STRAVA_BASE . 'includes/class-strava-admin.php';
require_once SW_STRAVA_BASE . 'includes/class-strava-shortcodes.php';
require_once SW_STRAVA_BASE . 'includes/class-strava-widgets.php';

register_activation_hook(__FILE__, function () {
  if (!wp_next_scheduled('sw_strava_cron_refresh_cache')) {
    wp_schedule_event(time() + 60, 'hourly', 'sw_strava_cron_refresh_cache');
  }
});

register_deactivation_hook(__FILE__, function () {
  wp_clear_scheduled_hook('sw_strava_cron_refresh_cache');
});

add_action('plugins_loaded', function () {
  (new SW_Strava_Admin())->init();
  (new SW_Strava_Shortcodes())->init();
  (new SW_Strava_Widgets())->init();
});

add_action('wp_enqueue_scripts', function () {
  wp_register_style('sw-strava-frontend', plugins_url('assets/frontend.css', __FILE__), [], SW_STRAVA_VER);
  wp_enqueue_style('dashicons');

  // Frontend theme variables (configured in Admin)
  $opt = get_option(SW_STRAVA_OPT, []);
  if (!is_array($opt)) $opt = [];

  $primary = isset($opt['color_primary']) ? sanitize_hex_color($opt['color_primary']) : '#2f6fed';
  $table_head_bg = isset($opt['color_table_head_bg']) ? sanitize_hex_color($opt['color_table_head_bg']) : $primary;
  $table_head_fg = isset($opt['color_table_head_fg']) ? sanitize_hex_color($opt['color_table_head_fg']) : '#ffffff';
  $row_alt = isset($opt['color_row_alt']) ? sanitize_hex_color($opt['color_row_alt']) : '#eef4ff';
  $widget_bg = isset($opt['color_widget_bg']) ? sanitize_hex_color($opt['color_widget_bg']) : '#ffffff';
  $title_bg = isset($opt['color_title_bg']) ? sanitize_hex_color($opt['color_title_bg']) : $primary;
  $title_fg = isset($opt['color_title_fg']) ? sanitize_hex_color($opt['color_title_fg']) : '#ffffff';
  $border = isset($opt['color_border']) ? sanitize_hex_color($opt['color_border']) : '#e5e5e5';

  // sanitize_hex_color can return null
  $primary = $primary ?: '#2f6fed';
  $table_head_bg = $table_head_bg ?: $primary;
  $table_head_fg = $table_head_fg ?: '#ffffff';
  $row_alt = $row_alt ?: '#eef4ff';
  $widget_bg = $widget_bg ?: '#ffffff';
  $title_bg = $title_bg ?: $primary;
  $title_fg = $title_fg ?: '#ffffff';
  $border = $border ?: '#e5e5e5';

  $css = ':root{' .
    '--sw-primary:' . $primary . ';' .
    '--sw-table-head-bg:' . $table_head_bg . ';' .
    '--sw-table-head-fg:' . $table_head_fg . ';' .
    '--sw-row-alt:' . $row_alt . ';' .
    '--sw-widget-bg:' . $widget_bg . ';' .
    '--sw-title-bg:' . $title_bg . ';' .
    '--sw-title-fg:' . $title_fg . ';' .
    '--sw-border:' . $border . ';' .
  '}';

  wp_add_inline_style('sw-strava-frontend', $css);

  wp_register_script(
    'sw-strava-frontend',
    plugins_url('assets/frontend.js', __FILE__),
    ['jquery'],
    SW_STRAVA_VER,
    true
  );

  wp_localize_script('sw-strava-frontend', 'SW_STRAVA', [
    'ajax_url' => admin_url('admin-ajax.php'),
    'nonce' => wp_create_nonce('sw_strava_ajax'),
  ]);
});

