<?php
if (!defined('ABSPATH')) exit;

class SW_Strava_Widgets {
  public function init(): void {
    add_action('widgets_init', function () {
      register_widget('SW_Widget_Strava_Activities');
      register_widget('SW_Widget_Strava_Stats');
      register_widget('SW_Widget_Strava_Latest');
    });
  }
}

class SW_Widget_Strava_Activities extends WP_Widget {
  public function __construct() {
    parent::__construct('sw_strava_activities', 'Strava: Aktivitätenliste');
  }
  public function form($instance) {
    $year = esc_attr($instance['year'] ?? gmdate('Y'));
    $type = esc_attr($instance['type'] ?? 'all');
    $per_page = esc_attr($instance['per_page'] ?? 20);
    $width = esc_attr($instance['width'] ?? '');
    ?>
    <p><label>Jahr <input class="widefat" name="<?php echo $this->get_field_name('year'); ?>" value="<?php echo $year; ?>"></label></p>
    <p><label>Typ (all/Ride/Run/…) <input class="widefat" name="<?php echo $this->get_field_name('type'); ?>" value="<?php echo $type; ?>"></label></p>
    <p><label>Anzahl <input class="widefat" name="<?php echo $this->get_field_name('per_page'); ?>" value="<?php echo $per_page; ?>"></label></p>
    <p><label>Breite (optional, z.B. <code>420px</code> oder <code>60%</code>)
      <input class="widefat" name="<?php echo $this->get_field_name('width'); ?>" value="<?php echo $width; ?>"></label>
    </p>
    <?php
  }
  public function update($new, $old) {
    return [
      'year' => sanitize_text_field($new['year'] ?? gmdate('Y')),
      'type' => sanitize_text_field($new['type'] ?? 'all'),
      'per_page' => intval($new['per_page'] ?? 20),
      'width' => sanitize_text_field($new['width'] ?? ''),
    ];
  }
  public function widget($args, $instance) {
    echo $args['before_widget'];
    $width = trim((string)($instance['width'] ?? ''));
    if ($width !== '') {
      echo '<div class="sw-strava-widget-wrap" style="width:' . esc_attr($width) . ';">';
    }
    echo do_shortcode('[strava_activities year="'.esc_attr($instance['year'] ?? gmdate('Y')).'" type="'.esc_attr($instance['type'] ?? 'all').'" per_page="'.esc_attr($instance['per_page'] ?? 20).'"]');
    if ($width !== '') {
      echo '</div>';
    }
    echo $args['after_widget'];
  }
}

class SW_Widget_Strava_Stats extends WP_Widget {
  public function __construct() { parent::__construct('sw_strava_stats', 'Strava: Statistiken'); }
  public function form($instance) {
    $year = esc_attr($instance['year'] ?? gmdate('Y'));
    $group = esc_attr($instance['group'] ?? 'type');
    $width = esc_attr($instance['width'] ?? '');
    ?>
    <p><label>Jahr <input class="widefat" name="<?php echo $this->get_field_name('year'); ?>" value="<?php echo $year; ?>"></label></p>
    <p><label>Gruppierung (total/type) <input class="widefat" name="<?php echo $this->get_field_name('group'); ?>" value="<?php echo $group; ?>"></label></p>
    <p><label>Breite (optional, z.B. <code>420px</code> oder <code>60%</code>)
      <input class="widefat" name="<?php echo $this->get_field_name('width'); ?>" value="<?php echo $width; ?>"></label>
    </p>
    <?php
  }
  public function update($new, $old) {
    return [
      'year' => sanitize_text_field($new['year'] ?? gmdate('Y')),
      'group' => sanitize_text_field($new['group'] ?? 'type'),
      'width' => sanitize_text_field($new['width'] ?? ''),
    ];
  }
  public function widget($args, $instance) {
    echo $args['before_widget'];
    $width = trim((string)($instance['width'] ?? ''));
    if ($width !== '') {
      echo '<div class="sw-strava-widget-wrap" style="width:' . esc_attr($width) . ';">';
    }
    echo do_shortcode('[strava_stats year="'.esc_attr($instance['year'] ?? gmdate('Y')).'" group="'.esc_attr($instance['group'] ?? 'type').'"]');
    if ($width !== '') {
      echo '</div>';
    }
    echo $args['after_widget'];
  }
}

class SW_Widget_Strava_Latest extends WP_Widget {
  public function __construct() { parent::__construct('sw_strava_latest', 'Strava: Letzte Aktivität'); }
  public function form($instance) {
    $year = esc_attr($instance['year'] ?? gmdate('Y'));
    $width = esc_attr($instance['width'] ?? '');
    ?>
    <p><label>Jahr <input class="widefat" name="<?php echo $this->get_field_name('year'); ?>" value="<?php echo $year; ?>"></label></p>
    <p><label>Breite (optional, z.B. <code>420px</code> oder <code>60%</code>)
      <input class="widefat" name="<?php echo $this->get_field_name('width'); ?>" value="<?php echo $width; ?>"></label>
    </p>
    <?php
  }
  public function update($new, $old) {
    return [
      'year' => sanitize_text_field($new['year'] ?? gmdate('Y')),
      'width' => sanitize_text_field($new['width'] ?? ''),
    ];
  }
  public function widget($args, $instance) {
    echo $args['before_widget'];
    $width = trim((string)($instance['width'] ?? ''));
    if ($width !== '') {
      echo '<div class="sw-strava-widget-wrap" style="width:' . esc_attr($width) . ';">';
    }
    echo do_shortcode('[strava_latest year="'.esc_attr($instance['year'] ?? gmdate('Y')).'"]');
    if ($width !== '') {
      echo '</div>';
    }
    echo $args['after_widget'];
  }
}
