(function ($) {
  function getInt($el, key, fallback) {
    let v = $el.data(key);
    if (v === undefined || v === null || v === '') v = $el.attr('data-' + key);
    v = parseInt(v, 10);
    return isNaN(v) ? fallback : v;
  }

  function setLoading($wrap, isLoading) {
    $wrap.find('.sw-strava-loading').toggle(!!isLoading);
    if (isLoading) {
      $wrap.find('.sw-strava-prev, .sw-strava-next').prop('disabled', true);
    }
  }

  function updatePager($wrap, page, totalPages) {
    $wrap.data('page', page).attr('data-page', page);
    $wrap.find('.sw-strava-page').text(page);
    $wrap.find('.sw-strava-pages').text(totalPages);

    $wrap.find('.sw-strava-prev').prop('disabled', page <= 1);
    $wrap.find('.sw-strava-next').prop('disabled', page >= totalPages);
  }

  function updateSortIndicators($wrap) {
    const field = $wrap.data('sort-field') || $wrap.attr('data-sort-field');
    const dir = ($wrap.data('sort-dir') || $wrap.attr('data-sort-dir') || 'desc').toLowerCase();

    $wrap.find('th[data-sort]').removeClass('sw-sort-asc sw-sort-desc');
    const $th = $wrap.find('th[data-sort="' + field + '"]');
    $th.addClass(dir === 'asc' ? 'sw-sort-asc' : 'sw-sort-desc');
  }

  function loadPage($wrap, page) {
    const year = $wrap.data('year') || $wrap.attr('data-year');
    const type = $wrap.data('type') || $wrap.attr('data-type');
    const perPage = getInt($wrap, 'per-page', 20);
    const fields = $wrap.data('fields') || $wrap.attr('data-fields') || '';
    const sortField = $wrap.data('sort-field') || $wrap.attr('data-sort-field') || 'start_date';
    const sortDir = ($wrap.data('sort-dir') || $wrap.attr('data-sort-dir') || 'desc').toLowerCase();

    setLoading($wrap, true);

    $.post(SW_STRAVA.ajax_url, {
      action: 'sw_strava_activities_page',
      nonce: SW_STRAVA.nonce,
      year: year,
      type: type,
      per_page: perPage,
      page: page,
      fields: fields,
      sort_field: sortField,
      sort_dir: sortDir
    })
      .done(function (res) {
        if (!res || !res.success) {
          console.warn('Strava AJAX error', res);
          return;
        }
        $wrap.find('.sw-strava-rows').html(res.data.rows_html);
        updatePager($wrap, res.data.page, res.data.total_pages);
        updateSortIndicators($wrap);
      })
      .fail(function (xhr) {
        console.error('AJAX failed', xhr);
      })
      .always(function () {
        setLoading($wrap, false);
        const cur = getInt($wrap, 'page', 1);
        const total = parseInt($wrap.find('.sw-strava-pages').text(), 10) || cur;
        $wrap.find('.sw-strava-prev').prop('disabled', cur <= 1);
        $wrap.find('.sw-strava-next').prop('disabled', cur >= total);
      });
  }

  // Pagination
  $(document).on('click', '.sw-strava-table .sw-strava-prev', function () {
    const $wrap = $(this).closest('.sw-strava-table');
    const page = getInt($wrap, 'page', 1);
    if (page > 1) loadPage($wrap, page - 1);
  });

  $(document).on('click', '.sw-strava-table .sw-strava-next', function () {
    const $wrap = $(this).closest('.sw-strava-table');
    const page = getInt($wrap, 'page', 1);
    loadPage($wrap, page + 1);
  });

  // Activities header sort (server-side + keeps pagination correct)
  $(document).on('click', '.sw-strava-table th[data-sort]', function () {
    const $wrap = $(this).closest('.sw-strava-table');
    const field = $(this).data('sort');

    const curField = $wrap.data('sort-field') || $wrap.attr('data-sort-field');
    let curDir = ($wrap.data('sort-dir') || $wrap.attr('data-sort-dir') || 'desc').toLowerCase();

    let nextDir = 'desc';
    if (curField === field) nextDir = (curDir === 'desc') ? 'asc' : 'desc';

    $wrap.data('sort-field', field).attr('data-sort-field', field);
    $wrap.data('sort-dir', nextDir).attr('data-sort-dir', nextDir);

    // back to page 1 after resort
    $wrap.data('page', 1).attr('data-page', 1);
    loadPage($wrap, 1);
  });

  // Stats header sort (client-side, current table only)
  $(document).on('click', '.sw-strava-stats th[data-sort-client]', function () {
    const $table = $(this).closest('table');
    const idx = $(this).index();
    const asc = !$(this).hasClass('sw-sort-asc');

    $table.find('th').removeClass('sw-sort-asc sw-sort-desc');
    $(this).addClass(asc ? 'sw-sort-asc' : 'sw-sort-desc');

    const rows = $table.find('tbody tr').get();
    rows.sort(function (a, b) {
      const ta = $(a).children().eq(idx).text().trim();
      const tb = $(b).children().eq(idx).text().trim();

      const na = (ta === '–') ? null : parseFloat(ta.replace(/\./g, '').replace(',', '.'));
      const nb = (tb === '–') ? null : parseFloat(tb.replace(/\./g, '').replace(',', '.'));

      // numeric if possible, else string
      if (na !== null && !isNaN(na) && nb !== null && !isNaN(nb)) {
        return asc ? (na - nb) : (nb - na);
      }
      return asc ? ta.localeCompare(tb) : tb.localeCompare(ta);
    });

    $.each(rows, function (_, r) { $table.children('tbody').append(r); });
  });

  // initialize indicators on load
  $(function () {
    $('.sw-strava-table').each(function () {
      updateSortIndicators($(this));
    });
  });
})(jQuery);
